#define vec2 float2
#define vec3 float3
#define vec4 float4
#define _max(a,b) (a)>(b)?(a):(b)
#define _min(a,b) (a)<(b)?(a):(b)
#define _abs(a)	 (a)>0.0f?(a):-(a)
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data,  __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 rgb_to_xyz(vec4 color) {
	float var_R = (color.x); //R from 0.0 to 255.0
	float var_G = (color.y); //G from 0.0 to 255.0
	float var_B = (color.z); //B from 0.0 to 255.0

	if (var_R > 0.04045f) {
		var_R = pow(((var_R + 0.055f) / 1.055f), 2.4f);
	} else {
		var_R = var_R / 12.92f;
	}
	if (var_G > 0.04045f) {
		var_G = pow(((var_G + 0.055f) / 1.055f), 2.4f);
	} else {
		var_G = var_G / 12.92f;
	}

	if (var_B > 0.04045f) {
		var_B = pow(((var_B + 0.055f) / 1.055f), 2.4f);
	} else {
		var_B = var_B / 12.92f;
	}

	var_R = var_R * 100.0f;
	var_G = var_G * 100.0f;
	var_B = var_B * 100.0f;

	//Observer. = 2.0°, Illuminant = D65
	float X = var_R * 0.4124f + var_G * 0.3576f + var_B * 0.1805f;
	float Y = var_R * 0.2126f + var_G * 0.7152f + var_B * 0.0722f;
	float Z = var_R * 0.0193f + var_G * 0.1192f + var_B * 0.9505f;

	return (vec4)(X, Y, Z, color.w);
}

vec4 xyz_to_lab(vec4 color) {

	float ref_X = 95.047f; //Observer= 2.0°, Illuminant= D65
	float ref_Y = 100.000f;
	float ref_Z = 108.883f;

	float var_X = color.x / ref_X;
	float var_Y = color.y / ref_Y;
	float var_Z = color.z / ref_Z;

	if (var_X > 0.008856f) {
		var_X = pow(var_X, (1.0f / 3.0f));
	} else {
		var_X = (7.787f * var_X) + (16.0f / 116.0f);
	}
	if (var_Y > 0.008856f) {
		var_Y = pow(var_Y, (1.0f / 3.0f));
	} else {
		var_Y = (7.787f * var_Y) + (16.0f / 116.0f);
	}
	if (var_Z > 0.008856f) {
		var_Z = pow(var_Z, (1.0f / 3.0f));
	} else {
		var_Z = (7.787f * var_Z) + (16.0f / 116.0f);
	}

	float L = (116.0f * var_Y) - 16.0f;
	float a = 500.0f * (var_X - var_Y);
	float b = 200.0f * (var_Y - var_Z);

	return (vec4)(L, a, b, color.w);
}

vec4 lab_to_lch(vec4 color) {

	const float MPI = 3.14159265359f;

	float var_H = atan2(color.z, color.y); //in GLSL this is atan2

	if (var_H > 0.0f) {
		var_H = (var_H / MPI) * 180.0f;
	} else {
		var_H = 360.0f - (_abs(var_H) / MPI) * 180.0f;
	}

	float C = sqrt(pow(color.y, 2.0f) + pow(color.z, 2.0f));
	float H = var_H;

	return (vec4)(color.x, C, H, color.w);
}
// ---------------------------
vec4 lch_to_lab(vec4 color) {
	float a = cos(radians(color.z)) * color.y;
	float b = sin(radians(color.z)) * color.y;

	return (vec4)(color.x, a, b, color.w);
}

vec4 lab_to_xyz(vec4 color) {
	float var_Y = (color.x + 16.0f) / 116.0f;
	float var_X = color.y / 500.0f + var_Y;
	float var_Z = var_Y - color.z / 200.0f;

	if (pow(var_Y, 3.0f) > 0.008856f) {
		var_Y = pow(var_Y, 3.0f);
	} else {
		var_Y = (var_Y - 16.0f / 116.0f) / 7.787f;
	}
	if (pow(var_X, 3.0f) > 0.008856f) {
		var_X = pow(var_X, 3.0f);
	} else {
		var_X = (var_X - 16.0f / 116.0f) / 7.787f;
	}
	if (pow(var_Z, 3.0f) > 0.008856f) {
		var_Z = pow(var_Z, 3.0f);
	} else {
		var_Z = (var_Z - 16.0f / 116.0f) / 7.787f;
	}

	float ref_X = 95.047f; //Observer= 2.0 degrees, Illuminant= D65
	float ref_Y = 100.000f;
	float ref_Z = 108.883f;

	float X = ref_X * var_X;
	float Y = ref_Y * var_Y;
	float Z = ref_Z * var_Z;

	return (vec4)(X, Y, Z, color.w);
}

vec4 xyz_to_rgb(vec4 color) {
	float var_X = color.x / 100.0f; //X from 0.0 to  95.047      (Observer = 2.0 degrees, Illuminant = D65);
	float var_Y = color.y / 100.0f; //Y from 0.0 to 100.000;
	float var_Z = color.z / 100.0f; //Z from 0.0 to 108.883;

	float var_R = var_X * 3.2406f + var_Y * -1.5372f + var_Z * -0.4986f;
	float var_G = var_X * -0.9689f + var_Y * 1.8758f + var_Z * 0.0415f;
	float var_B = var_X * 0.0557f + var_Y * -0.2040f + var_Z * 1.0570f;

	if (var_R > 0.0031308f) {
		var_R = 1.055f * pow(var_R, (1.0f / 2.4f)) - 0.055f;
	} else {
		var_R = 12.92f * var_R;
	}
	if (var_G > 0.0031308f) {
		var_G = 1.055f * pow(var_G, (1.0f / 2.4f)) - 0.055f;
	} else {
		var_G = 12.92f * var_G;
	}
	if (var_B > 0.0031308f) {
		var_B = 1.055f * pow(var_B, (1.0f / 2.4f)) - 0.055f;
	} else {
		var_B = 12.92f * var_B;
	}

	float R = var_R;
	float G = var_G;
	float B = var_B;

	return (vec4)(R, G, B, color.w);
}


vec4 rgb_to_lch(vec4 color) {
	vec4 xyz = rgb_to_xyz(color);
	vec4 lab = xyz_to_lab(xyz);
	vec4 lch = lab_to_lch(lab);
	return lch;
}


vec4 lch_to_rgb(vec4 color) {
	vec4 lab = lch_to_lab(color);
	vec4 xyz = lab_to_xyz(lab);
	vec4 rgb = xyz_to_rgb(xyz);
	return rgb;
}

vec4 rgb_to_lab(vec4 color) {
	vec4 xyz = rgb_to_xyz(color);
	vec4 lab = xyz_to_lab(xyz);
	return lab;
}

vec4 lab_to_rgb(vec4 color) {
	vec4 xyz = lab_to_xyz(color);
	vec4 rgb = xyz_to_rgb(xyz);
	return rgb;
}

float thrdB(float l)
{
    if (l < 10.f)
        return 0.f;
	float valIn = (l - 15.f) / 85.f;  
    float valOut = 1.f - pow(1.f-valIn,1.36f);
    return valOut * 100.f;
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha)
{	
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	vec4 col = INPUT(src_data, param, tc);
    vec4 lab = rgb_to_lab(col);
    lab.x = thrdB(lab.x);
	write_imagef(dest_data, coordinate, (float4)(col.xyz*(1.0f - (float)(alpha)/100.0f) + lab_to_rgb(lab).xyz*(float)(alpha)/100.0f, col.w));
}